# 第三章 开源项目发展现状

## GitHub中国项目活跃度及趋势

### 一、中国开源项目的总体现状

通过统计全域 GitHub 事件日志，可以看到近 5 年全球开源的总体活跃情况，各项指标都在明显上升，特别是疫情后，有一个加速上升的趋势。同时活跃仓库数量目前保持着大约 24% 左右的增速，显示了全球开源发展中的增速。

![在这里插入图片描述](https://img-blog.csdnimg.cn/971cababa9ae4cb18bb50345c7e8d91e.png#pic_center)
图1 全球 GitHub 事件日志、活跃仓库、活跃开发者五年趋势图

此节包含近五年中国项目在 GitHub 日志的事件总量、活跃仓库数量、活跃在中国项目上的开发者总量的变化趋势。
在经历了疫情前后的快速增长后，开始处于一个稳定的增长期。中国在2022年的日志事件和活跃仓库数均有明显的增长，相信在国家各项政策性意见的出台下，中国开源的发展会越来越好。

![在这里插入图片描述](https://img-blog.csdnimg.cn/f67ebe6918b44a578dab640011804490.png#pic_center)
图2 中国项目 GitHub 事件日志、活跃仓库、活跃开发者五年趋势图

### 二、中美企业对比
为了更好的展现中国企业在全球范围下的开源贡献整体水平，本报告通过对比美国头部企业参与开源贡献的数据来进行分析，四张表分别为：美国活跃度排名前十的开源贡献企业、中国活跃度排名前十的开源贡献企业、美国开源影响力排名前十的企业、以及中国开源影响力排名前十的企业，可以看到：
-美国的传统互联网大企业任然是活跃度与影响力排名靠前的主要来源。微软由于已使用 GitHub 作为大部分团队的日常开发平台，故项目数量较大，总活跃度第一，与第二名Google的差距逐渐拉大；著名的开源独角兽公司 HashiCorp 也榜上有名。
-中国的情况则是阿里巴巴的项目数量和总活跃度均为国内企业第一，但整体项目体量以及活跃度总量距离美国 Google 等大企业还有一定的差距；而中国的开源初创企业和项目则表现抢眼，按照项目平均活跃度，可以看到如 PingCAP（tidb，tikv）、Baidu（PaddlePaddle）、ESPRESSIF（esp-idf）、StarRocks（StarRocks）都脱颖而出。
-影响力指标更关注开发者生态，在影响力指标下，大体趋势和活跃度指标下的一样，体量上中美存在一定差距，在项目平均影响力上则相当，中国企业映云科技(EMQ)进入榜单，该公司成立于2017年，其主要的开源项目 emqx 有着相当不错的开发者生态。

进一步，本报告也详细分析了中国企业近 5 年的开源发展趋势，包括活跃度趋势与影响力趋势。可以看到阿里巴巴、百度、蚂蚁三家企业长期名列前茅；阿里长期排名榜首，而百度近几年也明显加大了对开源贡献的投入，初创企业 PingCAP 也是一直稳居第四的位置，需要注意的是鼎石科技（StarRocks）在2021年上榜并在2022年达到第8位，其下开源项目StarRocks数据库影响力不容忽视。

![在这里插入图片描述](https://img-blog.csdnimg.cn/5e52176747aa4fb59179f3c492920d4e.png#pic_center)

表1 美国企业活跃度 Top 10

![在这里插入图片描述](https://img-blog.csdnimg.cn/26fb70182d9d47fca45c002f07ecfe99.png#pic_center)

表2 中国企业活跃度 Top 10

![在这里插入图片描述](https://img-blog.csdnimg.cn/6e94b7f0a8ca40ae853450b5501f6b08.png#pic_center)

表3 美国企业影响力 Top 10

![在这里插入图片描述](https://img-blog.csdnimg.cn/29b7e266a024491f91b13dd004d70cb4.png#pic_center)

表4 中国企业影响力 Top 10

![在这里插入图片描述](https://img-blog.csdnimg.cn/abf053734a904929baa51f51dc4090fc.png#pic_center)

图3 中国企业活跃度 Top 10 2018 – 2022

![在这里插入图片描述](https://img-blog.csdnimg.cn/e648778a83224e0c9884bb64af2e2e1e.png#pic_center)

图4 中国企业影响力 Top 10 2018 - 2022

### 三、中国项目情况

在开源项目洞察这块，同样根据活跃度和影响力，分别比较了全球和中国排名前 20 的开源项目，可以看到：
-在单个项目上，中国主导的开源项目的活跃度和影响力距离全球顶级开源项目的活跃度与影响力还有一定的差距，特别是在影响力方面，是一个需要长期建设的生态指标，需要我们最大限度的融入到全球开源生态里面发展我国的开源项目。
-中国主导的开源项目中，来自百度的 PaddlePaddle 相关的两个项目保持上升 活跃度与影响力均位列第一，pingCAP 旗下的两个开源项目（TiDB、TiKV）与 StarRocks旗下的StarRocks数据库则表现不俗。
-在近 5 年的变化趋势上，活跃度方面，PaddlePaddle 相关的两个项目保持上升；影响力方面，shardingsphere 和 metersphere 则稳步上升。

![在这里插入图片描述](https://img-blog.csdnimg.cn/1566a74f1b894accbd9f7767d4d43bcc.png#pic_center)

表5 GitHub 全球项目活跃度 Top 20

![在这里插入图片描述](https://img-blog.csdnimg.cn/41e1178405c54b178d3b776bbeb85144.png#pic_center)

表6 中国项目活跃度 Top 20

![在这里插入图片描述](https://img-blog.csdnimg.cn/3c6a9c4e80dc41b290d9dc2ad002238a.png#pic_center)

表7 全球项目影响力 Top 20

![在这里插入图片描述](https://img-blog.csdnimg.cn/7ba8f466bea84334a94631f8327b0586.png#pic_center)

表8 中国项目影响力 Top 20

**近五年中国活跃度 Top 10 项目变化趋势图**
可以看出 Paddle 项目上升至第 1，tidb 上升至第 2，StarRocks 得益于其良好的开源生态以及全球的推广，在 2021 年上榜，并 2022 年直接上升至第 3 位，

![在这里插入图片描述](https://img-blog.csdnimg.cn/074a6bb7504b41d28dbf8bfd6d91227b.png#pic_center)
图5 中国项目活跃度 Top 10 2018 - 2022

**近五年中国影响力 Top 10 项目变化趋势图**
PaddleOCR 在 2020 年开源以来，活跃度和影响力都飞速进步，很快就进入了顶级项目行列。同样，metersphere 自 2020 年上榜以来影响力逐渐上升。从下图中同样可以看出 2020 年以来项目影响力竞争激烈，反映出中国开源项目积极的发展。

![在这里插入图片描述](https://img-blog.csdnimg.cn/9c138ea79ed040019890445af89b2326.png#pic_center)
图6 中国项目影响力 Top 10 2018 – 2022


### 四、应用领域项目分析
根据对 GitHub 中主流项目应用领域的标签数据，本节绘制了几个热⻔领域近几年项目发展情况，包括依赖包和框架、应用软件、系统软件、软件工具和非软件。

**各子领域影响力变化趋势**
由于当下软件组件化开发的推广，libraries and framework 影响力大幅领先其他领域，application software 和 software tools 影响力有一定上升趋势。

![在这里插入图片描述](https://img-blog.csdnimg.cn/1a6dcc5d5bbd4d34bd57d4999d5294dc.png#pic_center)
图7 应用领域子领域影响力2018 – 2022

**各子领域活跃度变化趋势**
与影响力指标类似，libraries and framework 在活跃度方面也大幅领先其他领域。

![在这里插入图片描述](https://img-blog.csdnimg.cn/f1d8f2f9a559485b9774e9f1e8710f82.png#pic_center)
图8 应用领域子领域活跃度2018 – 2022

**近五年应用领域项目影响力 Top 10 项目变化趋势图**

_依赖包和框架_
flutter 项目常年稳居第一，百度 paddle 影响力持续增长。

![在这里插入图片描述](https://img-blog.csdnimg.cn/40efff77c5dc4be7afa5ec2102dc11f3.png#pic_center)
图9 依赖包和框架影响力TOP 10 2018 – 2022

_应用软件_
home-assistant/core 项目影响力增长明显并且与其他项目逐渐拉开差距，该领域下的 top 10 项目影响力均有不同程度的增长

![在这里插入图片描述](https://img-blog.csdnimg.cn/3954ca8d92f2461394a0b1d5395b5886.png#pic_center)
图10 应用软件影响力TOP 10 2018 – 2022

_系统软件_
nixpkgs 作为系统包管理工具是 Github 最活跃的项目之一，而 k8s 项目的影响力有所下降

![在这里插入图片描述](https://img-blog.csdnimg.cn/67d0cecfa95d4431bce1d4c7d5c0b5e4.png#pic_center)
图11 系统软件影响力TOP 10 2018 – 2022

_软件工具_
vscode 作为软件开发工具之一，深受广大开发者的喜爱，影响力常年位居第一，dotnet/runtime 项目在 2020 年影响力迅速增长位居第二。

![在这里插入图片描述](https://img-blog.csdnimg.cn/df5861f09da0412cb87dea83736621a9.png#pic_center)
图12 软件工具影响力TOP 10 2018 – 2022

_非软件_
非软件类项目主要以项目文档为主，其中 azure-docs 影响力常年位居第一
![在这里插入图片描述](https://img-blog.csdnimg.cn/f5a8fec3eadc4b1f98e1c428a628cc2e.png#pic_center)
图13 非软件影响力TOP 10 2018 – 2022

### 五、数据库领域项目分析
本小节从数据库领域角度出发，分别给出了数据库领域影响力和活跃度 Top 10 项目、数据库各子领域 Top 5 影响力和活跃度变化趋势以及近 5 年 Top 10 项目的影响力变化趋势

**数据库领域影响力 Top 10**
可以看出 Clickhouse 活跃度和影响力稳居第一，elasticsearch 其次。ClickHouse 是俄罗斯的 Yandex 于 2016 年开源的用于在线分析处理查询 MPP 架构的列式存储数 据库作为高性能的 OLAP 数据库，其性能十分优越，查询速度极快。

![在这里插入图片描述](https://img-blog.csdnimg.cn/00ad60884e7a4bc4a725ab307c5c7dc7.png#pic_center)

表9 数据库领域影响力 Top 10

**数据库领域活跃度 Top 10**

![在这里插入图片描述](https://img-blog.csdnimg.cn/5f6e725e60e6447ca3406cc2611ff1e8.png#pic_center)

表10 数据库领域活跃度 Top 10

**数据库领域项目 Top 10 影响力变化趋势** 
从下图可以看出 Clickhouse 双指标均在2022年上升至第一位，elasticsearch 和 spark 有一定的回落，排名较后的项目双指标均有不同程度的增长。

![在这里插入图片描述](https://img-blog.csdnimg.cn/82104650900a4899877cb3b6d961ddfe.png#pic_center)
图14 数据库领域项目影响力TOP 10 2018 – 2022

**数据库领域项目 Top 10 活跃度变化趋势**

从趋势图中可以看出，在 2018-2020 年项目之间的活跃度差距较为明显，在 2022 年竞争逐渐激烈，反映出数据库项目积极的发展。

![在这里插入图片描述](https://img-blog.csdnimg.cn/6f1acade92224eaaadfa207f5075ee30.png#pic_center)
图15 数据库领域项目活跃度TOP 10 2018 – 2022

**数据库各子领域 Top 5 影响力变化趋势**

本节给出了数据库下各个主要子领域的影响力变化趋势，从趋势图可以看到，关系型数据库连年位居第一且影响力不断增长，其他类型数据库影响力均处于稳定期。

![在这里插入图片描述](https://img-blog.csdnimg.cn/016c062e1d914102b36b5e4b4049d3fd.png#pic_center)
图16 数据库子领域影响力TOP 5 2018 – 2022

**数据库各子领域 Top 5 活跃度变化趋势**

本节给出了数据库下各个主要子领域的活跃度变化趋势，从趋势图可以看到，关系型数据库活跃度在2022年增长迅速，其他类型数据库活跃度每年相对稳定。

![在这里插入图片描述](https://img-blog.csdnimg.cn/2df3a72569ac4412abdccdb00d294e4c.png#pic_center)
图17 数据库子领域活跃度TOP 5 2018 – 2022

### 六、编程语言 Top 10 排行榜
从下表中可以看出 JavaScript 仍然是当前最热门的编程语言，Python紧随其后。
![在这里插入图片描述](https://img-blog.csdnimg.cn/111f92c5f2e446528b5d33a3fb5c10e7.png#pic_center)
表11 编程语言 Top 10 排行榜



## 开源操作系统现状

国产开源操作系统在近年来得到飞速发展，从趋势上看，已经进入行业整体即将起飞的阶段。从传统上看，操作系统的开发属于底层基础软件，复杂性很高，开发和维护资源投入需求巨大，却很难直接转化成商业利益回报，因此一直以来大型企业对于自研操作系统的决策都是非常谨慎的，而国内专业从事操作系统开发的软件企业、操作系统厂商（OSV），却都一直处境艰难，直到今天在中国尚未出现像红帽公司（Red Hat）这样具有全球影响力的操作系统厂商，更不用说微软这样的产业巨头。近年来随着政府一系列鼓励本土操作系统发展的政策推动，国家应对信息安全威胁的需求，再加上国内市场的旺盛需求，以及国内科技实力的提升，国产操作系统的发展进入了一个迅猛发展的前夜，腾飞指日可待。

大部分的国产操作系统都是基于开源的Linux，同时也出现了像Open Harmony这样完全自主开发的操作系统。在数据中心和服务器领域，基于开源Linux操作系统进行定制化和创新是仍然是主流，但相对于早年，近年来中国操作系统行业最大的变化在于，国内系统软件社区的飞速发展和普及，社区化是相对于以前靠单个公司和组织的开发模式的显著变化，也是国内操作系统行业近年来飞速发展的引擎。国内目前有四个主流的开源操作系统社区，分别是欧拉社区（openEuler），龙蜥社区（OpenAnolis），OpenCloudOS以及OpenHarmony；目前这四个社区都已经捐赠或者正在捐赠到同一个开源基金会，开放原子基金会（OpenAtom Foundation）。

促使国内开源操作系统社区出现和迅速发展的直接因素之一，是国际开源操作系统CentOS的停止服务。CentOS是一个基于Red Hat商业版企业的开源的Linux发行版，由于与Red Hat商业版（RHEL）100%兼容，以及免费，开源的特性，长期以来国内有大量企业和用户在使用和定制基于CentOS的Linux操作系统。2020年12月，Red Hat和CentOS项目组宣布CentOS Linux项目停止维护，到2021年底CentOS8系列已经完成生命周期支持，另外CentOS7也将于2024年6月底停止支持，由此寻求CentOS的替代成为众多企业的当务之急。

龙蜥社区就是在这样的背景下应运而生，龙蜥操作系统（Anolis OS）为CentOS用户提供了平滑迁移过渡的方案，同时在此基础上，社区在操作系统的性能，安全性，云原生支持，运维等各个领域进行了自主创新。

欧拉社区是另外一个国产操作系统社区的代表，但定位略有不同，欧拉操作系统（Euler OS）并未将兼容CentOS作为主要目标，而是希望通过社区创新，打造自主的面向数字基础设施的开源操作系统，成为一个独立发展生态的社区。

OpenCloudOS则致力于打造一个完全中立、全面开放、安全稳定、高性能的操作系统及生态，在云原生、稳定性、性能、硬件支持等方面有一定的技术支撑，可以平等全面地支持所有硬件平台。

OpenHarmony是开放原子基金会旗下另外一个重要的开源操作系统社区，与其他基于Linux的操作系统不同，OpenHarmony从一开始就致力于构建一个全新，自主的系统架构和生态，目标是面向全场景、全连接、全智能时代、基于开源的方式，搭建一个智能终端设备操作系统的框架和平台，促进万物互联产业的繁荣发展；目前OpenHarmony在物联网（IoT）和嵌入式领域得到了长足发展，生态繁荣，社区参与者覆盖面很广。

在桌面操作系统领域，尽管随着时间的推移，越来越多的用户开始使用Linux桌面操作系统，但与Windows和macOS相比，Linux桌面用户的数量仍然相对较少。根据各种市场调查，全球Linux桌面市场份额大约在2％到4％之间。中国桌面Linux的市场情况与全球大体一致，同时在国产化和信创的政策推动下，国产桌面Linux操作系统在政企办公OA，金融，能源，电力等领域得到长足的发展。主要的国产桌面操作系统厂商包括统信，麒麟，红旗，中科方德，普华，中兴新支点等，同时也出现了OpenKylin这样专注于桌面操作系统的开源技术社区。

从生态上看，应用软件特别是专业应用软件的缺失，硬件（包括显卡驱动，指纹识别器和一些特殊硬件等）驱动支持不足仍然是制约国内桌面Linux操作系统普及的重要原因。

## 开源与云计算的现状
云计算如今已是IT业界的主流技术，越来越多的用户选择云计算平台作为自己软件业务的基础设施，而云计算业务带来的IT产业营收比重也越发凸显。云计算的概念从上世纪八十年代发端，到真正成型落地广为人知，开源理念和开源软件在其中起到了决定性的推动作用。首先系统软件里，以Linux为代表的开源的操作系统是云计算软件技术栈里坚实的基础，还有开源的虚拟化技术对于计算资源的池化也是必不可少的一环，包括Xen，KVM，QEMU等开源项目。云计算技术需要管理的资源，除了计算资源之外，网络资源和存储资源也是缺一不可的，同样，在网络技术软件栈和存储技术软件栈里，各种逐渐成熟的开源技术和开放标准，也加速了云计算时代的到来。作为云计算产业的先锋Amazon AWS，不可否认就是架构在这一系列的开源软件之上的。在AWS稳定的技术表现和成功的商业模式的带动下，一系列开源的云计算基础架构管理软件风起云涌，而时至今日，OpenStack最终成为最为成功和唯一事实上的标准云基础设施开放平台。

同时，在过去几年里，容器化和容器资源的管理，也逐渐走向成熟，并快速被广大开发人员和厂商所采用，也标志了云（计算）原生时代的到来。在此中起关键作用的还是几个核心的开源软件项目，首先是Linux kernel里的几个核心技术带来了容器化的可能，然后Docker工具横空出世让业界快速拥抱了容器技术，容器资源从单节点走向大规模集群的过程中，Kubernetes渐渐成为了容器资源调度和编排的事实标准，可称为云原生时代的云操作系统。

存储服务支撑了应用的状态、数据的持久化，是应用得以运行的基础。云原生存储是一种用于云原生环境的存储技术，是云原生的重要组成部分，特征主要包括可用性、可扩展性、高性能、一致性以及持久性等。近年来我国出现了一批优秀成熟的开源云原生存储项目，具有代表性的有PingCap的分布式事务键值数据库TiKV，阿里巴巴的云原生镜像分发系统Dragonfly和分布式内存数据管理引擎Vineyard，以及OPPO为大规模容器平台设计的分布式文件系统CubeFS等。

### 开源与数据库

早在20世纪50年代，互联网技术（ARPANET）的先驱们就十分推崇同行评审和开放反馈，用户组通过共享源代码，相互扶持并激发创新，到20世纪90年代互联网诞生时，协作、开放、创新的价值观就已植根于互联网的内核之中。 

在数据库技术领域，始于20世纪70年代的Ingres项目，代码使用BSD许可证分发，在其基础之上，以各种形式演绎出包括Sybase、Microsoft SQL Server、NonStop SQL、Informix、PostgreSQL等著名产品，成为数据库历史上最成功的项目之一。 

本质上，开源软件和闭源软件都只是一种软件研发和消费模式，在不同时期和场景有着各自独特的竞争力与优势体现。时至今日，开源软件依托其社区开发模式，能更快地实现产品迭代和用户触达，进而形成免费软件结合付费服务的业务模式，并进一步通过云获得价值回报，MongoDB等数据库都在探索这一模式。此外，从市场竞争战略来看，软件开源已经成为后来者扩大其市场影响力、追赶头部企业的重要手段。 

国内开源数据库的发展，经历了借鉴、发展、创新的全历程，早期国产数据库的探索者人大金仓就是以PostgreSQL为基础，在国产数据库的发展中，基于PostgreSQL开源路线的产品，成为了一支主要流派，其中以瀚高数据库发展时间最为悠久，在充分掌握PostgreSQL核心代码并逐步发展后，通过二次开源的方式发展自主ivorySQL开源社区，借助社区提供源源不断的技术迭代能力。而NewSQL的代表产品TiDB则是源自2013年Google Spanner/F1论文的技术实现，更多的NoSQL数据库也相继开源，如悦数科技在2019年开源了它的原生图数据库Nebula Graph的alpha版。自2019年以来，国内开源数据库领域快速发展，大事件频现，推动国内开源产业的蓬勃兴盛。 

据DB-Engines的数据显示，2021年1月，开源数据库的流行度首次超过商业数据库，并持续领先，截止到2023年5月，开源数据库的流行度继续扩大了相对商业数据库的优势。（见图5）。全球383款数据库中，开源数据库占据51.7%，排名前十的数据库中，开源数据库占据六席。据墨天轮的中国数据库流行度排行榜，198个数据库产品中包含13个开源的数据库产品，而榜单的前十名就有5个开源产品。从数据库开源项目的现状来看，全球最受欢迎的两种开源数据库MySQL与PostgreSQL是一系列数据库产品衍生的基础，中国数据库流行度排行榜中，源自MySQL和PostgreSQL的数据库数量分别为12和18。在今天的数据库领域，开源已经成为主要的趋势和潮流。特别是基于PostgreSQL的开源数据库项目，由于在供应链安全性和开源协议的商业友好性方面更具优势，未来发展趋势进一步被看好。

![](https://img-blog.csdnimg.cn/696691be6e2e4148b043d3a25e1e67af.png#pic_center)

图1 DB-Engines商业数据库和开源数据库流行度趋势对比

2015年以后，中国的开源数据库项目进一步发展并逐渐成熟。一些项目已经在技术上取得了重大突破，并在国内外获得了广泛的认可和应用。主要的代表有TiDB（HTAP分布式数据库）、OceanBase（分布式数据库）、IvorySQL（关系型数据库）等在国际上逐渐崭露头角。同时，中国开源数据库项目的社区规模不断扩大，国际影响力逐渐增强。各个数据库项目的社区活跃度提升，开发者数量增加，贡献者不断涌现。同时，中国开源数据库项目也开始积极参与国际标准制定和国际合作，加强与国际数据库社区的交流与合作。逐步开启了中国开源社区的国际化阶段。未来，中国开源数据库项目有望继续发展，为国内外用户提供更多高质量、高性能的开源数据库解决方案。

表13为被广泛使用的中国主导的开源数据库。
|项目名称 | 项目地址 | 项目简介 |
| ------ | ------ | ------ |
| TiDB | https://github.com/pingcap/tidb | TiDB是由PingCAP公司研发的分布式HTAP数据库产品, 具备水 平扩容或缩容、金融级高可用、实时HTAP、云原生分布式、兼容 MySQL5.7协议和MySQL生态等重要特性。|
| ApacheDoris | https://github.com/apache/incubator-doris |ApacheDoris是百度研发的现代化MPP分析型数据库产品, 可以支持10PB以上的超大数据集实时分析查询。 |
| TDengine | https://github.com/taosdata/TDengine| TDengine是涛思数据推出的专为物联网、车联网、工业互联网、IT运维等设计和优化的大数据平台。|
| NebulaGraph| https://github.com/vesoft-inc/nebula-graph |NebulaGraph是悦数科技推出的分布式、易扩展的原生图数据库, 能够承载千亿个点和万亿条边的超大规模数据集毫秒级查询。 |
| StarRocks | https://github.com/StarRocks/starrocks | StarRocks是鼎石科技推出的新一代全场景MPP数据库, 采用全面向量化技术，目标是成为新一代流批融合的极速湖仓（Lakehouse） 。|
| openGauss| https://github.com/opengauss-mirror/openGauss-server | openGauss是一款由华为在2020年开源的关系型数据库管理系统, 采用木兰宽松许可证v2发行, 深度融合了华为在数据库领域的企业级经验, 打造国内根社区。 |
| PolarDB-fOr- PostgreSQL| https://github.com/ApsaraDB/PolarDB-for-PostgreSQL | PolarDB-for-PostgreSQL是阿里云自主研发的云原生数据库产品，100%兼容PostgreSQL，采用基于Shared-Storage的存储计算分离架构,，具有极致弹性、毫秒级延迟、HTAP能力。 |
| IvorySQL | https://www.ivorysql.org/zh-cn/ | IvorySQL是瀚高数据库主导的具备强大Oracle兼容能力的开源数据库项目。具备高兼容性和高可用性，IvorySQL基于并100%兼容最新版PostgreSQL。IvorySQL社区是一个新生代，开放、合作和共享的开源数据库社区。IvorySQL全球开发组承诺始终保持与PostgreSQL最新版本内核同步。 |
| OceanBase| https://github.com/oceanbase/oceanbase | OceanBase是由蚂蚁集团自主研发的高可用、高性能、横向扩展、 兼容SQL标准的企业级分布式关系数据库。 |
| TBase | https://github.com/Tencent/TBase | TBase是腾讯基于PostgreSQL研发的分布式HTAP数据库, 适用于海量数据、高并发的数据处理场景。 |
| gStore| https://github.com/pkumod/gstore | gStore是—种原生基于图数据模型（NativeGraphModel）的RDF数据管理系统, 由邹磊教授领导的北京大学王选计算机研究所数据管理实验室（PKUMOD）研发。 |
| IoTDB | https://github.com/apache/iotdb | IoTDB是清华大学研发的—款聚焦工业物联网、高性能、轻量级的 时序数据管理系统, 2014年项目启动, 2018年成为中国高校首个进入Apache孵化器的项目。 |

表13 中国主导的开源数据库

### 开源与云计算的趋势、挑战和机遇

2022年，随着云基础设施、网络和存储等技术发展的深入，以及以容器和微服务为代表的云原生技术兴起，云计算的发展呈现出如下的趋势，也带来了新的挑战与机遇。

**绿色云计算：**

也有场合称作可持续计算（Sustainable Computing），随着云计算的普及，数据中心作为云计算的基础设施，消耗大量电力并产生大量温室气体排放，数据中心的能耗和碳排放问题日益严重，政府、企业和公众对此越来越关注。一方面能源成本上升使得运营数据中心的成本增加，为降低成本，企业开始寻求能效更高的解决方案，另一方面，各国政府对于碳排放的限制和法规，以及环保组织的倡导，促使企业采取更环保的措施。绿色云计算是指在云计算环境中采取节能、低碳、环保的方法和技术，以减少能源消耗、降低运营成本并减缓气候变化。绿色云计算的目标是在维持服务质量的同时，降低能源消耗和环境影响。

目前有多种应用于绿色云计算的技术方案，除了利用太阳能、风能、水能等可再生能源为数据中心供电，降低碳排放外，人们可以利用绿色建筑设计、合理布局、高效照明等手段，降低数据中心的能源消耗，也可以采用低功耗处理器、高效内存和绿色存储技术，减少设备的能源消耗。不论是大型数据中心（如谷歌、微软和亚马逊等云计算提供商正在利用可再生能源为其数据中心供电）还是中小型数据中心都可以利用绿色云计算技术可以帮助这些企业降低能源成本，提高设备的能效，并减少对环境的影响，而且采用绿色云计算技术可以使它们在遵守政府法规的同时，提高竞争力和市场声誉。

在软件方面，人们通过虚拟化技术对服务器进行资源整合，提高资源利用率，从而降低能耗。在容器方面，值得一提的是NRI(Node Resource Interface)技术, 它可用于控制节点资源的公共接口, 是CRI兼容的容器运行时插件扩展的通用框架。它为扩展插件提供了跟踪容器状态，并对其配置进行有限修改的基本机制。到现在为止，已经有越来越多的节点资源细粒度管理方案开始探索使用NRI实现，包括为了可持续计算而管理的资源。当NRI成为节点细粒度资源分配管理方案后，可以进一步提高资源管理方案的标准化，提高相关组件的可复用性。

在冷却技术方面，人们还可以采用高效的冷却系统和设备，如液冷、自然冷却或热管技术，降低数据中心的冷却成本，譬如2022年浪潮宣布的浪潮服务器要“All in液冷”。

最后，人们还可以采用智能能源管理系统，实时监控数据中心的能源消耗，采取节能措施以优化资源分配。许多大型数据中心都在采用绿色云计算技术，以降低能源消耗和环境影响。绿色云计算已经成为一个重要的议题，越来越多的企业、政府和组织开始关注并采取措施降低云计算对环境的影响。通过实施绿色云计算技术和策略，我们可以在享受云计算带来的便利和效率的同时，保护地球环境。

**人工智能和机器学习：**
随着大数据和计算能力的发展，人工智能（AI）和机器学习（ML）技术在过去的几年里取得了显著的进展，它可以应用于如自动驾驶、金融风控、智能医疗和智能制造等各个领域。企业和研究机构对于利用人工智能和机器学习技术解决复杂问题和提高工作效率的需求日益增长。

2022年，ChatGPT的流行更是把人工智能发展推向了新高潮，ChatGPT是一款由OpenAI开发的大型自然语言处理（NLP）模型，基于GPT-4架构。它可以理解和生成自然语言文本，广泛应用于聊天机器人、自动摘要、翻译等多个领域，它深刻地影响着我们的生活、工作和学习的方方面面。

在这个爆发式增长的行业里，云计算为工智能和机器学习提供了基础算力服务，云计算提供商如谷歌、亚马逊和微软，不仅提供了一系列预构建的人工智能和机器学习服务AI-as-a-Service (AIaaS)，如语音识别、图像识别和自然语言处理等，使企业能够轻松集成和部署AI功能，而且还提供了强大的分布式计算能力，支持在多台计算机上并行执行机器学习训练任务，从而缩短训练时间。除此之外，云计算提供商还提供了基于GPU和专用AI芯片（如谷歌TPU）的计算资源，为AI提供了强大的计算能力。

**云原生技术：**
在如今的云下半场中，如火如荼的云原生技术是云计算发展的主线。在CNCF基金会对云原生技术的解释中提到，云原生要用一个开源软件栈解决三个问题：一是把软件应用程序切分为多个微服务；二是把每个部分打包成容器；三是动态地编排这些容器以优化系统资源。因此，把一个单体软件应用解耦成许多微服务，并让这些微服务在各自的容器中高效协作，是云原生的重要内容和发展方向。

相对于物理机和虚拟机而言，容器是很轻量化的技术，在等量资源的基础上能创建出更多的容器实例是当下紧迫需求，容器或微服务都需要接受管理并有序接入外部环境，从而完成调度、负载均衡、分配等任务。简单且高效地管理快速增长的容器实例，是容器编排系统的主要任务，而Kubernetes就是容器编排和管理系统中的最佳选择。Kubernetes的核心是如何解决自动部署、扩展和管理容器化（Containerized）应用程序。未来，随着云原生技术的成熟和发展，企业会更多地采用云原生技术，而Kubernetes可能会继续发展，成为云原生应用部署和管理的事实标准。

**云安全：**
云计算的基础是资源共享，随着越来越多的企业将其基础设施迁移到云端，云安全将成为关键领域。云提供商可能会继续加大投资以确保客户的数据安全，并采取更严格的合规和隐私政策，因此未来安全服务在云计算的发展过程中越来越重要。众所周知，数据在存储态和传输态时都已经有相应的加密机制对其进行有效保护，保障了数据的机密性和完整性，而数据在使用态时的保护正亟需新的技术填补空白。机密计算（Confidential Computing）正是基于硬件的受信任执行环境中执行计算来保护正在使用的数据，它基于建立硬件的可信执行环境（Trusted Execution Environment，TEE），如英特尔SGX和TDX，ARM TrustZone，AMD SEV/SEV-ES/SEV-SNP、RISC-V Keystone等技术，为数据在云原生环境中的安全使用提供保障。随着容器化和微服务架构的普及，确保这些技术的安全性可能会成为一个关键议题。云服务提供商和企业可能会采取更多措施来保护容器和微服务，包括运行时保护、网络隔离和加密等。目前在CNCF中就有Inclavare Containers和 Confidential Containers等开源机密计算项目，它们已经成为云安全的新趋势。

**5G与云计算融合：**
5G（第五代移动通信技术）和云计算的结合为各种行业和应用带来了巨大的潜力。5G技术提供了更高的带宽、更低的延迟和更强的连接密度，这些特点使得5G与云计算的融合可以大幅提升现有应用的性能，同时创造出全新的应用场景。

譬如，边缘计算是一种将计算资源和服务部署在网络边缘（靠近数据源或用户）的技术。在某种意义上，边缘计算可以认为是云计算的扩展和延伸。边缘计算发展到今天，5G的低延迟特性使得边缘计算成为现实，可以在云计算和本地设备之间实现更高效的资源分配，但是构建分布式边缘计算基础设施工具和架构仍处于初级阶段，在边缘计算技术发展里，仍有诸多问题有待解决。国内厂商发起的KubeEdge、OpenYurt、SuperEdge等开源项目继续推进，通过边缘自治，云边流量治理，边缘设备管理等功能来实现云边协同。边缘计算可以减少数据传输延迟，提高实时性能，特别适用于自动驾驶、工业自动化、增强现实（AR）和虚拟现实（VR）等应用场景，这些边缘应用场景都是5G与云计算融合的典型案例。

再譬如，在物联网（IoT）领域，5G技术可以支持更高的连接密度，这意味着大量的物联网设备可以同时连接到网络。与云计算相结合，物联网应用可以实现更高的数据处理能力、智能分析和远程管理，这对于智能城市、智能交通和智能家居等领域具有重要意义。随着5G技术的不断发展和推广，它将与云计算形成更紧密的结合，创造出更多创新应用，为各种行业和领域带来巨大的商业价值和社会影响。可以说，5G和云计算的融合将成为推动数字化转型和智能化发展的关键力量。

## 开源与人工智能

### 大型自然语言处理预训练模型发展情况
近年来，随着深度学习的发展和大规模数据的积累，自然语言模型的规模和性能都有了显著的提升。2022年11月，OpenAI发布正式发布ChatGPT，仅仅2个月后，其成为迄今为止用户数最快破亿的应用，使自然语言处理（NLP）及大型自然语言模型（LLM）成为2023年最受关注的科技话题。自然语言模型的应用已进入快速发展和变革的时期，对高校学习、科研、产业应用、投融资等各社会组织活动将产生重大影响。

人工智能是国家战略的重要组成部分，是未来国际竞争的焦点和经济发展的新引擎。近年来，中国人工智能行业受到各级政府的高度重视和国家产业政策的重点支持 。为了把握新一轮科技革命和产业变革机遇，推动我国人工智能事业高质量发展，中国在“十四五”期间制定了《“十四五”智能制造发展规划》等一系列顶层设计文件，并从多个方面给予了政策扶持和资源投入。
根据《“十四五”智能制造发展规划》，中国将以数字化转型为主线，以关键核心技术突破为支撑，以场景创新为引领，以标准化建设为保障，以协同创新为动力，在2025年前实现我国智能制造水平显著提升。具体而言，在技术层面，《规划》提出加强算法创新与应用、推动算力基础设施建设、完善数据基础支撑体系等关键任务；在应用层面，《规划》提出培育一批具有全球竞争力的领军企业、打造一批示范性应用场景、构建一批开放共享平台等目标；在生态层面，《规划》提出优化政策环境、完善法律法规、加强伦理道德约束等措施。通过以上举措，《规划》旨在促进我国从传统制造大国向数字化制造强国转变，在全球产业链中占据更高端位置，在新一轮产业变革中赢得主动权。

**1.政策方面：**

1)加强基础研究和应用研究：《国务院办公厅关于全面加强新时代语言文字工作的意见》提出进一步推进计算机视觉、智能语音处理、生物特征识别、自然语言理解、智能决策控制以及新型人机交互等关键技术的研发和产业化，支持语言文字基础研究和应用研究，鼓励学科交叉，完善相关学科体系建设。同时，要加强语言文字数据资源的收集、整理、标注和共享，构建开放式的语言文字大数据平台，促进语言文字信息化水平的提升。建立健全自然语言处理和自然语言大模型的研发、评测、标准化、共享等体系，培育一批具有国际竞争力的核心技术和产品，提升我国在多语种文本分析、机器翻译、知识图谱、对话系统等领域的水平和影响；
2)支持产业创新和转化：《促进新一代人工智能产业发展三年行动计划（2018-2020年）》提出大力推动语言文字与人工智能、大数据、云计算等信息技术的深度融合，加强人工智能环境下自然语言处理等关键问题研究和原创技术研发，加强语言技术成果转化及推广应用，支持创业创新。同时，要加快推进自然语言处理和自然语言大模型的应用落地，打造一批具有示范效应的解决方案，促进产学研用协同创新。此外，要搭建开放包容的创新生态平台，鼓励各类主体参与自然语言处理和自然语言大模型的研究开发和商业化运营，为广大科技工作者和企业家提供政策支持和服务保障；
3)促进多领域多场景应用：以《2021年我国智能语音产业相关政策规划汇总》为例，梳理了我国部分地区出台的多项政策规划，鼓励开发自然语言处理和自然语言大模型在教育、文化、媒体、司法、医疗等行业领域的应用，提升应用场景中对于自然语言处理和生成的效率与效果，进而推动生产效率提升，并基于在具体场景中的使用，形成“使用——开发——研究”的反馈链路，加速基础研究与应用开发；通过使用自然语言大模型，可以提高各个领域和场景下的自然语言理解和生成效率和质量，实现更加便捷、准确和高效的信息交流和知识获取，并在以上领域建设国家新一代人工智能开放创新平台。

**2.科研方面：**

1)以鹏城实验室、智源研究院为代表的一系列科研机构的建立，进行重点攻关大规模自然语言处理领域的核心技术，逐步形成了以悟道、鹏程·盘古为代表的自然语言模型，并向产学研各界开放使用；以自由探索和目标导向相结合的体制机制，开展相关研究发表或支持发表国际AI顶会顶刊论文；与北京大学、清华大学、中国科学院等高校和科研机构建立紧密合作关系，共同培养人才和推进科技成果转化，有效促进了我国科研领域组织与人才在自然语言处理和语言模型方面不断努力和创新； 
2)国内的顶级高校，如清华大学、北京大学、复旦大学等知名高校已经成立了专门的自然语言实验室或研究组织，致力于自然语言处理和语言模型方面的研究和应用。如近期上线并开源的MOSS和ChatGLM-6B分别来自于复旦大学的邱锡鹏教授团队和清华大学孵化的智谱AI团队。高校在推动科研发展的三方面优势：一是拥有优秀的师资队伍，他们在国内外发表了大量高水平的论文，也培养了一批优秀的研究生和博士生；二是拥有强大的计算资源，他们能够利用高性能计算机和云平台进行大规模数据处理和模型训练；三是拥有广泛的合作伙伴，他们与政府、企业、社会等各界保持良好的沟通和交流，为自然语言处理技术在各个领域的落地和创新提供了支持；
3)在全球知名顶会期刊中，我国开发者体量、国内论文投递量及收录量也在逐年提高，根据斯坦福大学的AI Index统计，自2017年开始统计以来，中国AI相关的研发活力始终处于世界第二的位置；以ACL 2021为例，共有 1239 篇论文投稿来自中国大陆，其中 251 篇被接收，接收率为20.3%。

**3.中文大模型案例**

中国作为世界上最大的中文使用国家，也在积极探索大型语言模型的研究和应用。截至2023年，中国已经涌现出多个具有国际水平的大型中文预训练语言模型，如腾讯的混元、阿里巴巴的M6、百度的文心、鹏程·盘古、华为的盘古、智源的悟道和IDEA的封神榜等。这些模型都基于不同的架构和数据集进行了预训练，并且在不同领域展示了其强大的生成和理解能力。下面对这些模型进行简要介绍：

1)文心：文心大模型是百度为主体发布的产业级知识增强大模型，能够理解和生成自然语言，同时结合知识图谱，提升了学习效率和可解释性。文心大模型包括多个子模型，如ERNIE、PLATO、鹏城-百度·文心等，分别在语言理解、文本生成、跨模态语义理解、对话互动等领域取得多项技术突破。其中鹏城-百度·文心是全球首个知识增强千亿大模型，参数规模达到2600亿，在60多项典型任务中取得了世界领先效果，在各类AI应用场景中均具备极强的泛化能力。
2)悟道：悟道是北京智源人工智能研究院开发的一系列超大规模预训练语言模型，包括悟道1.0和悟道2.0。悟道2.0于2021年6月发布，参数量达到1.75万亿，并在世界公认的9项 Benchmark 上达到了世界第一，在多项基准测试中超越OpenAI GPT-3、DALL·E以及Google ALIGN等先进模型；除此之外，智源通过FlagAI开源平台，将悟道GLM正式开源。
3)鹏程·盘古：鹏程·盘古α大模型是鹏城实验室与华为联合研发的全球首个完全开源开放、以中文为核心的两千亿参数的预训练生成语言模型，鹏程·盘古系列大模型包括鹏程·盘古α、鹏程·盘古增强版、鹏程·盘古多语言大模型和鹏程·盘古对话生成大模型。其中鹏程·盘古增强版创新应用了多任务学习、任务统一格式、提示微调和持续学习等技术，对鹏程·盘古α基本版模型进行了能力扩展和增强。鹏程·盘古多语言大模型，首个以中文为中心的多语言&机器翻译模型，并在2022 IKCEST “一带一路”国际大数据竞赛中获得第二名。鹏程·盘古对话生成大模型是基于盘古α的开放域对话系统，可以与用户进行自然、流畅和有趣的对话。
4)华为盘古：华为盘古β大模型是循环智能与华为云联合推出千亿参数中文语言预训练模型，鹏城实验室提供算力支持。华为盘古β是2020年4月25日发布的Transformer encoder-decoder的中文理解模型，在权威的中文语言理解测评基准CLUE榜单中，总成绩及阅读理解、分类任务单项均排名第一。
5)混元：2022年底，混元1T大模型利用腾讯太极机器学习平台的高效算力和低成本网络，用千亿模型热启动的情况下，可以在256张显卡上一天内完成训练。该模型在国内最权威的自然语言理解任务榜单CLUE上取得了优异的成绩，并且已经成功应用于腾讯广告、搜索、对话等多个核心业务场景。
6)M6： M6模型是一种基于多模态（语言、图像、视频等）的人工智能预训练模型，具有10万亿级别的参数量，是中文社区最大的跨模态预训练模型。该模型通过一系列技术创新，大幅降低了训练能耗和时间，并且拥有强大的认知和创造能力。该模型在电商、制造业、文学艺术、科学研究等领域有广泛应用前景，并且已经实现了商业化落地。
7)封神榜：2021年11月，IDEA研究院正式发布了“封神榜”开源体系——一个以中文驱动的基础生态系统，其中包括了预训练大模型，特定任务的微调应用，基准和数据集等。我们的目标是构建一个全面的，标准化的，以用户为中心的生态系统。截至目前，封神榜体系中包含：二郎神、闻仲、燃灯、太乙、余元、周文王等模型。

### 发展建议

**提升算力水平**

算力是支撑大规模预训练语言模型训练和部署的关键因素，需要开发和使用高效率、高性能、低成本的计算平台和硬件设备，并优化并行化和分布式计算策略。随着对模型性能要求的不断提升，对于训练模型所需的算力规模势必会不断增加，因此，集中力量建设“中国算力网”，像使用电力一样使用算力，将成为未来我国人工智能基础建设中的重要一环。
算力是支撑大规模预训练语言模型训练和部署的关键因素，需要开发和使用高效率、高性能、低成本的计算平台和硬件设备，并优化并行化和分布式计算策略。随着对模型性能要求的不断提升，对于训练模型所需的算力规模势必会不断增加，因此，集中力量建设“中国算力网”，像使用电力一样使用算力，将成为未来我国人工智能基础建设中的重要一环。通过中国算力网，实现AI算力资源的共享、调度和协同：一方面赋能用户根据需求灵活获取和使用各种类型和规模的AI算力服务，降低人工智能应用开发和部署的门槛和成本；另一方面也使得大规模算力跨区域协同计算成为可能，进而促进各地区、各行业、各领域之间的AI创新合作与交流，为我国人工智能产业发展提供强有力的支撑。

**加强数据资源建设**

数据是训练大规模预训练语言模型不可或缺的基础，需要收集和整理高质量、高覆盖度、高多样性的数据集，对数据进行更加精细、更加高效的工程化处理，也将成为未来人工智能快速发展的重要基石；与此同时，数据安全和隐私保护的投入也将对大规模数据带来重要的支持作用。以GPT-4为例，其在数据工程化，特别是在动态数据更新、小样本数据微调、多模态数据融合等方面工作的尝试都产生了非常值得关注的效果。因此，如何建立我国的数据标准以及数据工程化实现方案对于提升我国在自然语言处理及语言大模型成果产生方面，将产生重大意义。

**探索新颖有效的模型架构**

ChatGPT和GPT-4的成功证明，模型架构是决定大规模预训练语言模型性能和泛化能力的核心要素。因此，未来对于大模型的研发，也需要进行创新技术研究，考虑不同任务场景下特定领域知识和逻辑推理等因素。诸如多头注意力机制的改进、深度残差网络的优化、人类反馈强化学习（RLHF）的应用以及在多模态数据处理及应用方面的探索和尝试，均对新一代大模型的产生，提供了巨大的支持。随着数据量、计算资源、任务复杂度等因素不断增加，在保证可扩展性、可解释性、可控制性等方面也面临着新的挑战。因此，探索新颖而有效地语言模型架构不仅可以推动人工智能技术水平和应用价值的提升，也可以促进基础理论与前沿实践之间更紧密地结合。

**增强开放协作**

截至2023年3月，OpenAI仍未对GPT-3.5及GPT-4进行开源计划的发布，限制了其他研究者基于此的改进和创新，阻碍了模型的可解释性，也增加了模型被滥用和误用的风险。基于此，我国可以充分发挥制度优势，在中立机构的组织和协调下，团结各研究和开发力量，整合算力、数据资源，以开源开放方式进行大模型的研究与开发工作。通过开源协作，不仅能够提高我国在自然语言处理领域的技术水平和竞争力，也能够为全球社会贡献一种更公平、更透明、更可信赖的人工智能服务。同时，通过建立统一的标准和规范，我们也可以有效地保护用户隐私、维护网络安全、防止信息偏见和歧视等问题。


## 开源区块链项目现状介绍

### 一、2022-2023 年该领域发展现状

区块链技术是融合共识机制、密码学算法、智能合约的分布式账本技术，具备可追溯、不可篡改、公开透明等特性。区块链技术概念起源于比特币白皮书，但由于比特币系统技术栈中脚本语言的可编程性限制，早期的区块链生态局限在以比特币为代表的多个独立数字货币系统。2015年，以太坊系统引入图灵完备的通用编程语言作为合约开发语言，以太坊上快速涌现出一批数字资产驱动的金融类创新项目。区块链技术的迅猛发展得到各国政府和产学研界的广泛关注，在政策支持及市场驱动下，国内外诞生了一批拥有不同技术特点的区块链底层平台，应用场景也从金融领域拓展到各行各业。

区块链底层平台（以下简称区块链平台）是搭建区块链系统的关键基础设施，提供网络通信、分布式共识、合约执行、数据存储等基础功能，为各行业区块链应用落地提供支持。本文对比了国内区块链开源平台（见表1）与具备一定影响力的国外区块链开源平台（见表2）。由于本文重点关注我国区块链开源进展，国内区块链开源平台通过汇总行业白皮书、区块链信息服务备案文件、可信区块链测评、公开征集等多种渠道搜集得到，而国外区块链开源平台由于数量较多，仅遴选了star数在1000以上的知名区块链平台。

![表1：国内区块链开源平台基本信息](https://img-blog.csdnimg.cn/eab7fe5256b9486b9bc3657dbd2b6c5c.png#pic_center)
表1：国内区块链开源平台基本信息

![在这里插入图片描述](https://img-blog.csdnimg.cn/ac1a8d71d5c64dc893eded18a2786dbc.png#pic_center)
表2：国外知名区块链开源平台基本信息

可以看出，由于监管政策不同，国内外在区块链平台发展上具有明显差异。

-国外区块链平台发布时间较早，以公有链为主，大部分内置原生数字货币，并通过经济激励建设平台生态、完善社区治理。国内区块链平台以联盟链为主，大部分是无币区块链，侧重通过行业联盟与政府力量推动平台与社区建设。国内14个区块链开源平台中，联盟链共有10个，占比71.4%，国外具有较高影响力的14个区块链开源平台中，公有链共有10个，占比71.4%。
-在开源协议上，Apache 2.0占据国内开源平台的主流，占比达到42.9%，国外具有影响力的区块链开源平台中，GPL 3.0协议最多，其次是Apache 2.0协议。开源协议的使用与区块链平台类别有关，多数联盟链应用场景有闭源需求，因此联盟链平台普遍采用Apache 2.0协议，例如Hyperledger Fabric，而公有链平台则希望后续使用者持续开源，更多采用GPL 3.0协议。
-在开发语言上，无论国内外，Go语言市场占有率遥遥领先，达到46.4%，其次是C++，占比为17.9%。由于Go语言是以太坊和Hyperledger Fabric的主要开发语言，这一定程度上反映了这两个平台的生态影响力。

我们从影响力、star数、项目活跃度、最近维护时间、贡献者数量、主要贡献者数量等多个维度对国内外区块链开源项目进行比较（表3、表4）。

![在这里插入图片描述](https://img-blog.csdnimg.cn/b31d4b724bcb454a990b2a6291ff73d6.png#pic_center)
表3：国内区块链开源平台影响力与活跃度（RepChain由于托管在Gitee社区，影响力和活跃度缺失；WuTongChain, INT Chain由于影响力和活跃度较低，数据缺失）

![在这里插入图片描述](https://img-blog.csdnimg.cn/c9db331d6dea4aed9c97a84c10bcd36e.png#pic_center)
表4：国外知名区块链开源平台影响力与活跃度

对比可知，整体上，国内区块链开源平台影响力与国外有较大差距，在活跃度和贡献者数量上也有显著差距。

- 拥有1000个star数以上的国外区块链开源平台有14个，而国内开源平台仅有4个。
- 国内区块链开源平台的贡献者和核心贡献者数量比国外低一个数量级，例如，ChainSQL是项目规模最大的国内开源项目，贡献者、核心贡献者分别为137和53人，而以太坊分别是837和67人。
- 少数国内外区块链开源平台已超过两年没有维护项目代码，例如CITA、BCOS、Wutongchain、EOS、sia，其中BCOS较为特殊，其开发团队后续迁移到FISCO BCOS项目。

2022年，区块链平台聚焦于性能优化，完善技术栈配套组件。公有链头部平台以太坊Layer2快速发展，rollup成为主流链下扩容解决方案，吸引了超过200个项目部署，显著降低交易成本。此外，以太坊共识机制在9月从POW转向POS一事引发关注，该方案预期将解决以太坊状态数据庞大带来的网络中心化问题，并为后续的分片扩容提供基础。在联盟链上，国内开源平台技术积累趋向成熟，强调全面的信创适配，包括支持国密、国产数据库、适配国产操作系统、国产CPU等。此外，国内开源平台根据业务场景逐渐完善跨链互操作、管理运维平台、隐私保护等配套组件。

在加密资产应用场景上，2022年加密资产市场行情整体低迷，市值缩水严重，以DeFi为代表的热门赛道锁仓量腰斩。Terra崩盘、FTX集团申请破产等事件使投资者遭受重大损失，严重打击市场信心。尽管NFT数字藏品在年初开启了市场新一轮热度，但在年中达到峰值后持续降低。相比国外，国内的数字藏品在上半年也同样火热，但由于禁止二级市场交易与价格炒作、强调收藏属性，行业逐渐回归理性。在产业应用场景上，我国在政务协同、司法存证、供应链溯源等重点领域探索出可行的区块链应用方案，并通过开展国家区块链创新应用试点工作形成可复制推广的典型案例和做法经验。

### 二、问题与挑战

尽管我国有部分开源的区块链平台及配套组件，诞生了一批与实体行业结合的落地应用，但在开源领域还面临诸多挑战。

- 区块链行业领域尚未形成开源共识，区块链平台开源比例低、总体数量少，部分机构仅开源配套组件或开发文档，针对最核心的底层平台仍选择闭源。
- 区块链开源项目整体缺乏影响力，活跃度偏低，缺乏具备国际知名度的区块链行业团体与开源项目。
- 区块链开源项目的生态建设机制、社区治理机制尚不明朗，大多数项目由单家机构维护管理，行业联盟分布式协作治理程度较低。
- 缺乏具有认可度的开源测试框架、测试工具与测试数据集，关键性能指标可对比性不足。

### 三、前景、趋势与机遇

- 开源已成为软件发展的主流趋势，区块链作为构建分布式可信环境的关键技术，天然地在开源土壤中孕育成长。随着区块链技术的普及、软件社区对开源重视度的提升，是否开源将成为使用方选择区块链平台的重要指标。

- 我国在区块链开源项目的数量和质量上均有较大的提升空间。除底层平台外，开源项目方正在逐渐开源多语言SDK、跨链、控制台、开发模板等组件，以丰富开源生态，扩大开源社区影响力。

- 尽管国内外的政策环境不同，但开放是区块链的可信基础逐渐成为区块链从业者的共识。尽管目前我国应用场景以封闭的行业联盟链为主，但未来可能会诞生更多的开放联盟链、无币公链等提升开放能力。

### 四、发展建议

- 为扩大我国区块链开源社区的影响力，建议由具备一定影响力的行业协会牵头，联合开源底层平台的项目发布方、企事业单位、行业协会等，组建区块链开源联盟，设立联盟章程，通过制定区块链开源规范、举办区块链开源大会、定期发布开源发展报告等形式凝聚我国区块链开源社区力量。

- 加大政策支持，考虑由政府部门、企事业单位、行业协会等共同出资，依托开源联盟设立区块链开源基金会，为高质量开源项目提供资金支持，同时通过举办开源比赛、高校宣讲等形式普及区块链开源知识，吸引更多人加入开源社区。

## 国内DevOps领域的发展现状

DevOps 是 Dev 和Ops 的组合词，是开发和运营维护的总称，是目前已经收到国内外公认的确保高效研发运维流程的方法。 随着技术的发展，高效敏捷安全的研发诉求使得DevOps领域持续受到国内外开发者的关注。在GitLab 发布的《2023 Global DevSecOps Report Series——What’s next in DevSecOps》（GitLab 2023 DevSecOps 报告）提到这样一些数据：调研报告采访了5010 名开发者，其中有56%  的开发者正在使用DevOps 或 DevSecOp的方法论，比2022年的47%有所增加。而相较于同样的进行敏捷开发的方法论，只有DevOps/DevSecOps 是唯一有所增长的。

![在这里插入图片描述](https://gitcode.net/Beckyame/copu/-/raw/master/image%20(1).png)

图来源：《2023 Global DevSecOps Report Series——What’s next in DevSecOps》

这也正说明了DevOps （包含DevSecOps）的受重视程度稳步上升。

另一方面，中国信通院领衔联合超50家企业，其中超五成的问卷受访企业资产规模在5千万元以上，覆盖全国32个省级行政区近90个城市，发布了《中国DevOps现状调查报告（2022）》梳理国内DevOps实践现状，洞察中国DevOps转型新趋势，助力企业DevOps落地实践，促进全行业DevOps演进与变革，也印证了国内对于DevOps行业的关注。

## 国内开源的DevOps 项目综述

国外的DevOps 生态工具链百家争鸣，而且功能丰富：

**一、版本控制&协作开发**
1. 版本控制系统 Git
Git是一个开源的分布式版本控制系统，用以有效、高速的处理从很小到非常大的项目版本管理。
2. 代码托管平台 GitLab
GitLab是一个利用Ruby on Rails开发的开源应用程序，实现一个自托管的Git项目仓库，可通过Web界面进行访问公开的或者私人项目。
3. 代码评审工具 Gerrit
Gerrit是一个免费、开放源代码的代码审查软件，使用网页界面。利用网页浏览器，同一个团队的软件程序员，可以相互审阅彼此修改后的程序代码，决定是否能够提交，退回或者继续修改。它使用Git作为底层版本控制系统。
4. 版本控制系统 Bazaar
Bazaar 是一个分布式的版本控制系统，它发布在 GPL 许可协议之下，并可用于 Windows、GNU/Linux、Unix 以及 Mac OS 系统。

**二、自动化构建和测试**
1. Apache Ant
Apache Ant是一个将软件编译、测试、部署等步骤联系在一起加以自动化的一个工具，大多用于Java环境中的软件开发。
2. JMeter
JMeter 是 Apache 组织的开放源代码项目，它是功能和性能测试的工具，100% 的用 java 实现。
3. Gradle
Gradle 就是可以使用 Groovy 来书写构建脚本的构建系统，支持依赖管理和多项目，类似 Maven，但比之简单轻便。

**三、持续集成&交付**
1.Jenkins
Jenkins 的前身是 Hudson，它是一个可扩展的持续集成引擎。
2. Fabric
fabric8 是开源 Java Containers(JVMs) 深度管理集成平台。有了 fabric8 可以非常方便的从 UI 和 UX 一致的中央位置进行自动操作，配置和管理。fabric8 同时提供一些非功能性需求，比如配置管理，服务发现故障转移，集中化监控，自动化等等。
3. Travis CI
Travis CI 是一个基于云的持续集成项目， 目前已经支持大部分主流语言了，比如：C，PHP，Ruby，Python，Nodejs等等。

**四、部署工具**
1. Docker
Docker 是一个开源的应用容器引擎，让开发者可以打包他们的应用以及依赖包到一个可移植的容器中，然后发布到任何流行的 Linux 机器上，也可以实现虚拟化。
2. Chef
Chef 是一个系统集成框架，为整个架构提供配置管理功能。
3. Ansible
Ansible 提供一种最简单的方式用于发布、管理和编排计算机系统的工具，你可在数分钟内搞定。Ansible 是一个模型驱动的配置管理器，支持多节点发布、远程任务执行。默认使用 SSH 进行远程连接。无需在被管理节点上安装附加软件，可使用各种编程语言进行扩展。

而在国内同样也有同样的DevOps 工具链生态：

**一、DevOps 一体化平台**
1. 极狐GitLab
极狐GitLab不是GitLab的中文版本，而是GitLab 版本基础上融合了本土功能的中国发行版，集成了代码管理、CI/CD、项目敏捷管理、安全监控、效能管理等覆盖软件研发全生命周期的 DevOps能力，公司在中国独立运营。
2. CODO
企业多混合云、自动化运维、完全开源的云管理平台

**二、CI/CD（持续交付、持续集成）**
1. JIANMU（建木）
建木自动化平台以触发器、流程编排、任务分发等功能为平台核心，可以应用在各类使用场景下，包括但不限于，CI/CD、DevOps、自动化运维、多业务系统集成等场景的自动化。
2. flow.ci 
采用三端架构，服务端、Web、 Agent，支持服务端的负载均衡以提高稳定性。所有任务运行在 Agent 上，并可以配置任务主机来自动调度 Agent 提升构建速度。

**三、项目管理**
1. 禅道
禅道是一款专业的国产开源研发项目管理软件，集产品管理、项目管理、质量管理、文档管理、组织管理和事务管理于一体，完整覆盖了研发项目管理的核心流程。

**四、测试可观测性**
1. Metersphere
一站式的开源持续测试平台，遵循 GPL v3 开源许可协议，涵盖测试跟踪、接口测试、UI 测试和性能测试等功能，全面兼容 JMeter、Selenium 等主流开源标准，有效助力开发和测试团队充分利用云弹性进行高度可扩展的自动化测试，加速高质量的软件交付。
2. Datakit
一款开源、一体式的数据采集可观测Agent

国内的DevOps项目虽然不及国外开源项目种类丰富数量众多，但数量还是在稳步上升。

## 发展的趋势：DevOps 向 DevSecOps 迈进

DevSecOps 是DevOps的下一个阶段，其目的就是为了把安全性注入到持续集成和持续交付 (CI/CD) 管道中,使开发团队能够以 DevOps 的速度应对当今所面临的一些非常紧迫的安全挑战。

![在这里插入图片描述](https://gitcode.net/Beckyame/copu/-/raw/master/image__2_.png)

DevSecOps帮助软件供应链更上一个台阶，帮助开发者和研发将安全方案集成到整个软件开发交付流程。

面对日益复杂的开发环境，GitLab 对DevOps行业的发展有这样的趋势预测：

**预测一：保护供应链安全将是最高优先级**

安全依旧是整个组织的责任，未来将进一步 “左移”，并从集成开发环境（IDE）扩展到生产环境。安全左移的目的是加强软件供应链安全。

同时软件供应链安全将朝着以下三个方向发展。
- 一线工程师将在日常运维中承担更多的威胁管理职责。为了完成这一工作，开发人员需要在软件开发生命周期的每个阶段，实时了解漏洞情况和修复策略，降低生产环境中发生严重事件的可能性。
- 安全和合规团队将把软件安全保障策略融入代码，避免因耗时的手动安全审查，拖累开发速度。
- 一些引人瞩目的安全事件进一步凸显了软件开发风险。组织将建立审计流程，更好地评估和报告 SDLC 风险。这就要求组织设计好如何交付工件，以证明其开发工具链各方面部署的控件具有不变性。

**预测二：安全将深入DevOps教育**

加速 DevOps 向 DevSecOps 的演进，将安全视为 DevOps 培训和教育课程的重要部分，组织提供培训。

**预测三：AI/ML 将贯穿 SDLC**

AI将成为提高生产力的关键, DevOps 团队将数字化转型和业务分析与AI相结合，才能让数字化转型真正发生。 AI/ML将进一步助力研发加速、安全修复和提高自动化测试以及可观测性。

**预测四：价值流分析将在组织中发挥更大作用**

价值流分析将拓宽过去的开发工作流程，从而更全面地了解组织向其用户（内部和外部）提供的价值。

**预测五：可观测性将左移，以实现高效的 DevSecOps**

可观测性将在 SDLC 中进一步左移，在提高 DevSecOps 工作流效率方面发挥重大作用，包括 CI/CD、基础设施成本分析和趋势预测，以实现更好的容量规划。

预估中国围绕DevOps生态的开源软件提供软件也会往预测的几个方向发展。

## 开源芯片

### 2022-2023年开源芯片发展现状

相比于开源软件生态，开源芯片目前尚处于起步阶段，但发展势头迅猛，基于开源指令集RISC-Ⅴ的开源芯片生态正在快速崛起，为开源芯片生态的创新降低了技术门槛，为包括中国在内的广大发展中国家突破芯片领域的技术壁垒和市场壁垒带来了新机遇。从突破科技排他性角度来看，基于RISC-Ⅴ构建开源芯片生态，既有机会破解我国核心处理器芯片被“卡脖子”的现状，又能够协同全球各国特别是众多发展中国家共同构建开源处理器芯片生态，并开拓新兴应用市场。这是一种突破处理器芯片垄断格局的新路线，有望形成普惠世界的芯片领域的“人类命运共同体”。

2015年才逐渐兴起的RISC-V架构，经过仅仅8年时间的发展，就大有与X86、ARM三分天下之势。截至2022年底，全球有数万名工程师致力于RISC-V计划，基于RISC-V架构的处理器出货量已超过100亿颗，预计2025年，RISC-V芯片出货量将超过800亿颗。中国成为了RISC-V最为活跃的地区，中国的RISC-V开源芯片蓬勃发展，为推动全球范围内RISC-V的发展做出了贡献。阿里平头哥在生态大会上公布了其对RISC-V生态体系的支持计划。

当前开源芯片发展突出的趋势是：RISC-V不仅在工业控制、物联网、智能家居等对算力要求不高的领域已经占据主流市场，也正在向对算力有更高需求的移动设备、桌面应用、边缘计算等领域发展。而且已经看到RISC-V在数据中心服务器市场开始起步，比如微核芯推出对标ARM服务器端处理器核的RISC-V处理器核，并已聚焦于某些应用领域与合作伙伴展开深入合作。与X86、ARM在服务器领域提供通用芯片服务不同，RISC-V能够根据用户的应用场景进行定向的改进、优化，以给客户提供最优的解决方案。未来在云计算平台上，X86、ARM、RISC-V三方可以优势互补。

### 问题与挑战

国产开源芯片面临的主要挑战在于如何基于可控供应链实现具备全球竞争力的高性能芯片。

过去高性能芯片往往依赖于工艺进步来实现产品性能的升级。当前中美竞争背景下，高性能芯片产品和先进工艺被限制封锁，中国的高性能芯片产业必须进行供应链重组。对于中国的高性能芯片产品来说，难度在于如何在可控供应链条件下满足日益增长的算力需求，同时还有足够的商业竞争力应对全球竞争。一方面国产芯片只能使用落后国际先进工艺两三代以上的成熟工艺。另一方面目前高性能领域的商用处理器IP都是基于最先进的目标工艺（例如7nm、5nm、甚至3nm）开发的，这些商用IP在国内可控供应链条件下（12nm、14nm工艺）很难实现最优化的性能指标。国产高性能芯片必须走出自己的独立自主开发之路。

### 开源芯片前景、趋势与机遇

开源芯片的市场空间无限大。从高端的数据中心芯片，到桌面，到高端嵌入式，都需要开源芯片。

从宏观角度分析，开源的真正价值在于能够带动整个信息产业的发展。通过开源模式，用户企业都能够学习和了解高性能芯片技术，能够有能力和可能参与到芯片的定义和设计中，才能做到基于本领域深入挖掘潜在需求，从系统层面全面思考和优化解决方案，形成产业合力，也才能完成产业升级和信息化。

从微观角度看，开源芯片模式能够大幅度降低企业对高性能芯片技术的试用使用成本，因此有利于技术推广，扩大市场规模。过去开源软件的发展已经证明了这一点。

基于完全掌控在商业公司手中的闭源处理器IP，对用户企业的发展是一种限制，更是一种隐患，任何一家企业都不愿意把自己的未来与另一家不可控的商业公司紧密绑定。无论是基于商业因素还是非商业因素，过去两三年IC产业的混乱也证明闭源模式已经不适于整个信息产业的发展。而开源彻底解决了商业企业的信息安全可控问题。正是基于这个基础，所以很多用户企业会主动拥抱开源的RISC-V和开源高性能处理器，主动共建生态，这也是开源的最大优势！

对于国产高性能芯片来说，如果希望能够在可控供应链条件下实现足够商业竞争力的芯片产品，唯一的机会就在于与应用需求的深入结合。与应用深度结合，才能从根本上面向国内可控供应链来解决芯片的需求。在特定行业的专用领域专项性能方面，即便使用相对不够先进的工艺，也完全有可能以相对低的代价和成本实现领域内绝对性能的超越。结合行业应用的高性能自主可控供应链芯片对于国内新兴的芯片企业是非常好的机遇。对于RISC-V产业来说，只有以与应用需求结合作为抓手，与客户（用户）深入沟通，通过挖掘客户（用户）的潜在需求，平衡各个方面的成本、性能、功耗等指标因素，一方面提供足够商业竞争力的芯片产品，另一方面与应用深度结合，才能从点到面，逐渐将RISC-V的生态丰富成熟。

### 发展建议

国产开源芯片需要构建开放的生态体系，聚集各行业各企业的合力，通过与行业应用的深度结合，从需求端引导芯片生态的发展，以中国庞大的市场需求为基础，获取新兴产业的主导权和话语权，最终成就中国独立自主的半导体产业。RISC-V在这方面有得天独厚的优势。开源芯片让所有的芯片企业和开发者形成合力，让中国RISC-V生态面向全球市场竞争，从根本上解决自主可控的问题。

开源高性能芯片要想让用户敢用会用最终好用，首先必须有行业应用的机会，在某些行业领域率先落地，进行应用示范。在现有条件下，完全依靠纯粹的市场行为，由各个行业企业自发试用使用并纳入产品体系需要较长的时间。这是因为芯片研发的投入很大，技术门槛高，研发周期也长，这些因素在一定程度上抑制了行业企业进一步技术升级和产业升级的需求和意愿。建议在政策强有力的支持下，通过政府搭台，应用引导，企业合作，才能最终完成产业升级，在解决国家战略需求的同时，完成行业企业的技术升级和创新发展。


## 开源与元宇宙

元宇宙（Metaverse）是指一个虚拟的、以实时映射仿真的、具有高度互动性和沉浸感的虚拟世界，是互联网科技发展的新阶段。元宇宙不仅是一个虚拟的空间，而且是一个由数字资产、智能合约、虚拟现实和人工智能等多种技术组成的复杂系统。随着互联网技术的快速发展和物联网技术的广泛应用，元宇宙已经成为了互联网行业的热点话题，得到了政府和企业的高度关注和投入。开源世界是建立元宇宙的首选之地。

元宇宙包括以下几个关键词和技术：

**A：人工智能（AI）**
在元宇宙中，人工智能将会扮演非常重要的角色。人工智能可以用来实现虚拟现实和智能合约的自动化，让这些技术更加高效和灵活。例如，人工智能可以用来实现虚拟角色的自动化创建和管理，让玩家可以更加容易地沉浸在游戏中。此外，人工智能还可以用来实现自动化任务的管理，让游戏开发者可以更加容易地开发出更加复杂和有趣的游戏。

**B：区块链（Blockchain）**
区块链是元宇宙中非常重要的技术之一。区块链技术可以用来记录和存储虚拟资产、智能合约等数据。通过区块链技术，元宇宙中的数字资产可以被安全地验证和交易，避免了传统金融系统中的风险和欺诈。此外，区块链还可以用来实现虚拟资产的跨境交易和转移，让元宇宙更加便捷和安全。

**C：云计算（Cloud Computing）**
云计算是元宇宙中另一个非常重要的技术。云计算可以用来提供海量的计算资源和存储资源，让元宇宙更加高效和可靠。通过云计算，可以实现虚拟资产的快速交易和转移，让元宇宙更加便捷和安全。此外，云计算还可以用来实现虚拟世界中的数据管理和存储，让游戏开发者可以更加容易地管理和处理大量的数据。

**D：数据（Data）**
数据是元宇宙中非常重要的资源。在元宇宙中，数据将会扮演非常重要的角色。数据可以用来处理海量的虚拟资产和数据，让元宇宙更加安全和可靠。通过对数据的分析和处理，可以更加准确地模拟现实世界，让用户可以更加沉浸在游戏中。此外，数据还可以用来优化虚拟交易和虚拟货币的交易策略，让元宇宙更加高效和可持续。

元宇宙是一个从现实映射出来的虚拟世界，它需要多种技术的支持才能够成功。暂时，最核心的技术是人工智能、区块链和云计算，通过对这些技术的应用，元宇宙将会变得更加真实、互动、安全和高效。随着技术的不断发展和应用场景的不断拓展，元宇宙将实现更加丰富和多样化的应用场景。

在中国，元宇宙已经成为互联网行业的热点话题，得到了政府和企业的高度关注和投入。全球范围内，元宇宙市场的规模正在逐年增长，预计在2025年内将达到500亿美元。元宇宙作为数字经济的重要组成部分，将在教育、医疗、文化娱乐、游戏、金融等领域得到广泛应用。随着技术的不断发展和应用场景的不断拓展，元宇宙将实现更加丰富和多样化的应用场景。

### 一、2022-2023 年云宇宙发展现状

元宇宙项目的推出标志着中国互联网行业在数字经济领域的崛起。随着技术的不断进步和应用场景的不断拓展，国家要突围而出，就要找到我们的优势，再集中力量去推进，打造中国特色元宇宙。我们相信，中国特色元宇宙平台有望成为全球人人通用的元宇宙设备，并在未来的市场竞争中占据重要地位。由文旅开始的中国特色元宇宙是一个新的平台，通过区块链技术来确保数字资产的安全和可信。

#### 1.1 整体现状洞察
2022年，全球元宇宙市场持续稳步增长，各大公司纷纷加大投入，推动元宇宙技术不断创新和应用场景不断拓展。在中国市场，元宇宙也逐渐成为了互联网行业的热点话题，得到了政府和企业的高度关注和投入。  

#### 1.2 年度数据
全球元宇宙2021-2022年度数据：
1. 全球元宇宙总用户数量：截至2021年底，全球元宇宙总用户数量已经超过了10亿，而根据最新的数据，截至2022年底，全球元宇宙总用户数量已经超过了15亿。
1. 全球元宇宙总收入：2021年全球元宇宙总收入达到了250亿美元，而到了2022年底，这一数字已经增长到了300亿美元。
1. 全球元宇宙总支出：2021年全球元宇宙总支出达到了270亿美元，而到了2022年底，这一数字已经增长到了280亿美元。
1. 元宇宙相关企业数量：截至2021年底，全球范围内与元宇宙相关的企业数量已经超过了2.5万家，而到了2022年底，这一数字已经增长到了3.5万家。

中国元宇宙2021-2022年度数据：

1. 中国元宇宙总用户数量：截至2021年底，中国元宇宙总用户数量已经超过了5亿，而根据最新的数据，截至2022年底，中国元宇宙总用户数量已经超过了6亿。
1. 中国元宇宙总收入：2021年中国元宇宙总收入达到了150亿美元，而到了2022年底，这一数字已经增长到了180亿美元。
1. 中国元宇宙总支出：2021年中国元宇宙总支出达到了130亿美元，而到了2022年底，这一数字已经增长到了160亿美元。
1. 中国元宇宙相关企业数量：截至2021年底，中国范围内与元宇宙相关的企业数量已经超过了1.5万家，而到了2022年底，这一数字已经增长到了2.5万家。

而据IDC预计，全球元宇宙将会有十倍的增长，到2030年的一万五千亿。

_以上数据仅供参考，具体数字可能会因为时间的推移而有所变化。提供的数据来源包括但不限于：艾媒网、中国产业信息网、前瞻网、亿欧、中商产业研究院、中国信通院、中国互联网协会、IDC圈等_

#### 1.3 发展特点

在发展特点方面，2022年全球元宇宙市场呈现出了多样化、高科技、开放性等特点。在中国市场，政府和企业加大了对于元宇宙的投入和支持力度，各类应用场景不断涌现，用户数量和市场规模也不断增长。同时，各大公司也纷纷加大投入，推动元宇宙技术不断创新和应用场景不断拓展。

### 二、问题与挑战

#### 2.1 技术瓶颈

目前，元宇宙技术仍存在一些瓶颈和挑战，如虚拟现实技术的表现、延迟、体验等方面的问题。同时，也需要解决数字身份认证、数据隐私保护等方面的问题。

#### 2.2 政策风险

在政策风险方面，政府对于元宇宙的监管和管理还需要进一步加强和完善。同时，也需要加强对于数字身份认证、数据隐私保护等方面的监管和管理。

#### 2.3 市场失衡

在市场失衡方面，目前元宇宙市场还存在着内容创作者生存状况差、应用场景单一等问题。同时，也需要加强对于不同利益相关者之间的利益平衡和协调。

### 三、前景、趋势与机遇 - 中国特色元宇宙

#### 3.1 前景展望- 中国的优势

未来，元宇宙将在数字经济和数字文化领域发挥更加重要的作用，并推动数字化社会建设。而且，元宇宙不仅可以用于娱乐和游戏，还可以用于教育、医疗、旅游等多个领域和多样化的应用场景，为用户提供更全面、更丰富的服务。同时，也将带来更多的商业机遇和社会机遇。

所以如何让中国在全球元宇宙发展且剧烈竞争的同时，找出我们能领先的空间，推进中国特色元宇宙? 首先，在建议中国特色元宇宙之前，我们分析一下，中国在元宇宙发展的优势:

1．5G高速公路：利用5G技术将所有的VR实景同步到元宇宙中，实现高速传输和精准定位。

2．三维的空间标准: 北斗网格码标准则提供了时间和空间的标准，保证了元宇宙的准确性和稳定性。而北斗网格码跟国际的GPS有差异的技术，可留有空间给我们发展。

3．强大的硬件供应网络：中国的电商带动了整个硬件物流的简化，需要什么硬件零部件，在大城市里, 半天就可送到，若时间不急，一周便宜的原厂产品，无论多远也能送到，在中国特色元宇宙的发展下，虚实间(在线线下)的浸沉式的互动，新硬件的研发，二代智能物联网的发展将成为我国的强大优势。

当然，以上的3点，优势也是可以被抄袭、追赶的，但以下两个优势，则是中国特色元宇宙的关键点:

4．独特的中国历史文化：如果说元宇宙是未来的计算机，内容就是计算机吸引人的关键，中国拥有数千年的历史文化，可以将这些历史文化元素融入到元宇宙中，打造出独具无限内容的中国特色的元宇宙。

5．户外空间的实时数据：跟外国不同，中国内地的户外空间实时数据是中国政府的，因此，要做一个户外数字孪生所映射出来的元宇宙空间，是需要向国家申请的，也就是说，若有一个具有深厚历史文化的景点，可以开放实时数据，那就必是吸引全国的元宇宙开发者来参与，这就是中国特色元宇宙的核心。通过该平台，用户可以通个一个景点的实时据，来获取全国的不同元宇宙平行空间数据和信息，即可以通过北斗网格码来自由互相穿越不同的元宇宙，更好地体验元宇宙的魅力。

再者，中华五千年的文明加上今天中国特色社会主义，也是我们中国特色元宇宙可承先启后、永久广播传承的关键:

1.中国拥有全球最大的互联网用户群体，这为元宇宙的发展提供了庞大的用户基础和市场需求。同时，中国也是全球最大的电子商务市场和移动支付市场，这些市场基础设施为元宇宙的商业化应用提供了良好的支撑。

2.在东数西算的部署下，数据高度集中，网络极速增长覆盖全国，再配合绿色能源+算力+数据的云平台,元宇宙快速普及的成本相对低廉。

3.中国在参多开源技术虚拟现实技术、人工智能、区块链等领域拥有领先的技术和研发实力，这些技术和研发经验为元宇宙的发展提供了强有力的支持。

4.中国政府在元宇宙的政策制定和监管方面也具有重要的作用。政府可以通过出台相关政策和法规，规范和引导元宇宙的发展，保障用户的合法权益，防范风险和犯罪行为。

5.中国元宇宙产业链的完整性和发展速度也是其他国家难以比拟的。中国已经形成了从硬件设备、软件开发、内容创作、运营推广等全产业链条，这为元宇宙的发展提供了充分的保障和推动力。

6.中国元宇宙产业链的多样化也为其他国家提供了借鉴和启示。中国的元宇宙产业涵盖了数字娱乐、文化旅游、教育培训、电子商务等多个领域，这为其他国家提供了丰富的经验和参考，促进了全球元宇宙产业的协同发展。

综上所述，中国在元宇宙发展中具有巨大的潜力和优势，未来可以在技术研发、产业协同、政策支持等多个方面发挥更大的作用，推动元宇宙产业的快速发展和创新升级。

#### 3.2 未来机遇 - 中国特色元宇宙的实拖

未来，元宇宙将在数字文化、教育、医疗等领域带来更多商业机遇和社会机遇。同时，也需要加强对于不同利益相关者之间的利益平衡和协调。


